(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15666,        384]
NotebookOptionsPosition[     15280,        370]
NotebookOutlinePosition[     15615,        385]
CellTagsIndexPosition[     15572,        382]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"files", "=", 
    RowBox[{"FileNames", "[", "\"\<./pars*\>\"", "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Generate", " ", "population", " ", "average", " ", "of", " ", "speed"}], 
    ",", " ", 
    RowBox[{"aspect", " ", "ratio", " ", "and", " ", "persistence"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"finalresult", "=", 
    RowBox[{"First", "@", 
     RowBox[{"Last", "@", 
      RowBox[{"Reap", "@", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"tardirs", "=", 
           RowBox[{"FileNames", "@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"FileBaseName", "@", "file"}], "<>", "\"\</rng*\>\""}], 
             ")"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"msd", "=", 
           RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"result", "=", "\[IndentingNewLine]", 
           RowBox[{"Mean", "@", 
            RowBox[{"First", "@", 
             RowBox[{"Last", "@", 
              RowBox[{"Reap", "@", 
               RowBox[{"Do", "[", "\[IndentingNewLine]", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Sow", "@", 
                   RowBox[{"Flatten", "@", 
                    RowBox[{"First", "@", 
                    RowBox[{"Last", "@", 
                    RowBox[{"Reap", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"config", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{"tardir", "<>", "\"\</config.json\>\""}], "]"}]}],
                     ";", "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"\"\<SUBSTRATE_ADHESION_POLARIZABILITY\>\"", "/.", 
                    RowBox[{"(", 
                    RowBox[{"\"\<CELL\>\"", "/.", "config"}], ")"}]}], "]"}], 
                    "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"\"\<SUBSTRATE_DISSIPATION\>\"", "/.", 
                    RowBox[{"(", 
                    RowBox[{"\"\<CELL\>\"", "/.", "config"}], ")"}]}], "]"}], 
                    "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    
                    RowBox[{"tmp", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Averages/Speed\>\""}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"\"\<Mean\>\"", "/.", "tmp"}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Averages/AspectRatio\>\""}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"\"\<Mean\>\"", "/.", "tmp"}], "]"}], ";"}], 
                    "\[IndentingNewLine]", "]"}]}]}]}]}], ";", 
                  "\[IndentingNewLine]", 
                  RowBox[{"msd", "=", 
                   RowBox[{"Join", "[", 
                    RowBox[{"msd", ",", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Simple/MSD\>\""}], "]"}]}], "]"}]}], ";"}], 
                 "\[IndentingNewLine]", ",", 
                 RowBox[{"{", 
                  RowBox[{"tardir", ",", "tardirs"}], "}"}]}], 
                "]"}]}]}]}]}]}], ";", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", 
          RowBox[{"grpmsd", "=", 
           RowBox[{"GroupBy", "[", 
            RowBox[{"msd", ",", "First"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"meanmsd", "=", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"\"\<DeltaTime\>\"", "/.", "val"}], "//", "Mean"}], 
               ",", 
               RowBox[{
                RowBox[{"\"\<Mean\>\"", "/.", "val"}], "//", "Mean"}], ",", 
               RowBox[{
                RowBox[{"\"\<Mean\>\"", "/.", "val"}], "//", 
                "StandardDeviation"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"val", ",", "grpmsd"}], "}"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Fit", " ", "persistent", " ", "random", " ", "walk", " ", 
            "model"}], " ", "*)"}], "\[IndentingNewLine]", 
          RowBox[{"msdfit", "=", 
           RowBox[{"NonlinearModelFit", "[", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"meanmsd", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"2", ";;", 
                 RowBox[{"-", "1"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], 
             "\[IndentingNewLine]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"2", "*", 
                RowBox[{"A", "^", "2"}], "*", 
                RowBox[{"tau", "^", "2"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Exp", "[", 
                   RowBox[{
                    RowBox[{"-", "t"}], "/", "tau"}], "]"}], "+", 
                  RowBox[{"t", "/", "tau"}], "-", "1"}], ")"}]}], ",", 
               RowBox[{"tau", ">", "0.0001"}], ",", 
               RowBox[{"A", ">", "0"}]}], "}"}], "\[IndentingNewLine]", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"A", ",", "10"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"tau", ",", "10000"}], "}"}]}], "}"}], 
             "\[IndentingNewLine]", ",", "t", ",", 
             RowBox[{"Weights", "\[Rule]", 
              RowBox[{"1", "/", 
               RowBox[{
                RowBox[{"meanmsd", "[", 
                 RowBox[{"[", 
                  RowBox[{
                   RowBox[{"2", ";;", 
                    RowBox[{"-", "1"}]}], ",", "3"}], "]"}], "]"}], "^", 
                "2"}]}]}], ",", 
             RowBox[{"Method", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"NMinimize", ",", 
                RowBox[{"Method", "\[Rule]", "\"\<NelderMead\>\""}]}], 
               "}"}]}], ",", 
             RowBox[{"ConfidenceLevel", "\[Rule]", "0.999"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"AppendTo", "[", 
           RowBox[{"result", ",", 
            RowBox[{"tau", "/.", 
             RowBox[{"msdfit", "[", "\"\<BestFitParameters\>\"", "]"}]}]}], 
           "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"Sow", "@", "result"}], ";"}], "\[IndentingNewLine]", ",", 
         RowBox[{"{", 
          RowBox[{"file", ",", "files"}], "}"}]}], "]"}]}]}]}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Round", " ", "polarizability"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"finalresult", "[", 
      RowBox[{"[", 
       RowBox[{"k", ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"Round", "[", 
      RowBox[{"finalresult", "[", 
       RowBox[{"[", 
        RowBox[{"k", ",", "2"}], "]"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{"Length", "@", "finalresult"}]}], "}"}]}], "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Group", " ", "data", " ", "by", " ", "polarizability"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#1", " ", "polarizability"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{"(*", " ", 
   RowBox[{"#2", " ", "substrate", " ", "dissipation"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#3", " ", "speed"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#4", " ", "aspect", " ", "ratio"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#5", " ", "persistence"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalresult", "=", 
   RowBox[{"SortBy", "[", 
    RowBox[{"finalresult", ",", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result20", "=", 
   RowBox[{"20", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result20", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", "0.060"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result30", "=", 
   RowBox[{"30", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result30", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", "0.060"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result40", "=", 
   RowBox[{"40", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result40", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", "0.060"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result50", "=", 
   RowBox[{"50", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result50", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", "0.060"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result60", "=", 
   RowBox[{"60", "/.", 
    RowBox[{"GroupBy", "[", 
     RowBox[{"finalresult", ",", 
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result60", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", "0.060"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.740473733603188*^9, 3.7404737427275352`*^9}, {
   3.7404743487962112`*^9, 3.7404744048960133`*^9}, {3.740474553138999*^9, 
   3.740474576977846*^9}, {3.7404746317376842`*^9, 3.7404747301614637`*^9}, 
   3.7404747631252127`*^9, {3.740474799734309*^9, 3.74047480082445*^9}, {
   3.740475644270343*^9, 3.7404756860640287`*^9}, {3.740475807551002*^9, 
   3.7404759497260637`*^9}, {3.7404782973335257`*^9, 3.740478417250231*^9}, {
   3.7404784807142057`*^9, 3.7404784812280416`*^9}, {3.740562039096106*^9, 
   3.740562116814569*^9}, {3.740562223374802*^9, 3.740562234714262*^9}, {
   3.740562362929048*^9, 3.7405623843951073`*^9}, {3.740562420435128*^9, 
   3.740562658752768*^9}, 3.740563059159471*^9, {3.740563165138597*^9, 
   3.740563168861841*^9}, {3.740563243686219*^9, 3.740563246699719*^9}, {
   3.7405635603605328`*^9, 3.7405636014813633`*^9}, {3.740572893734722*^9, 
   3.74057289796838*^9}, 3.740573734870708*^9, {3.7406397600526047`*^9, 
   3.740639779423215*^9}, {3.740639996821848*^9, 3.740640057971066*^9}, {
   3.740640103630518*^9, 3.7406401046933813`*^9}, {3.740640148469658*^9, 
   3.74064016450458*^9}, {3.7406402223577623`*^9, 3.740640229789052*^9}, {
   3.740640468942174*^9, 3.740640491188933*^9}, 3.7407191473255672`*^9, {
   3.740719183834629*^9, 3.740719184076961*^9}, {3.7407194346455793`*^9, 
   3.7407194535781307`*^9}, {3.740725792331171*^9, 3.7407257958827457`*^9}, {
   3.740725829635138*^9, 3.740725857059944*^9}, {3.740726097172914*^9, 
   3.7407261001087503`*^9}, {3.74072711031215*^9, 3.740727117945513*^9}, {
   3.740727471560315*^9, 3.740727482062001*^9}, {3.7407312439849977`*^9, 
   3.74073125063311*^9}, {3.740731286377161*^9, 3.7407314900148573`*^9}, {
   3.740731742662314*^9, 3.740731747838747*^9}, {3.7407318166911917`*^9, 
   3.7407318175868473`*^9}, {3.740731889782754*^9, 3.7407318966421432`*^9}, {
   3.7407321268142967`*^9, 3.7407321328602667`*^9}, {3.740732258343833*^9, 
   3.7407322689325943`*^9}, {3.74073235640373*^9, 3.740732387789772*^9}, {
   3.740732444405113*^9, 3.7407324458294277`*^9}, {3.740736365662232*^9, 
   3.74073638087253*^9}, {3.741515947265167*^9, 3.7415159654773207`*^9}, {
   3.741516279061537*^9, 3.741516279204852*^9}, 3.742232364187449*^9, {
   3.742232647174975*^9, 3.742232654312055*^9}, 3.7422327322232103`*^9, {
   3.742232773664627*^9, 3.742232781296053*^9}, {3.742232830159417*^9, 
   3.742232846714345*^9}, 3.7422374827821093`*^9, {3.776509606385914*^9, 
   3.776509607047497*^9}, {3.776509644049261*^9, 3.776509734092114*^9}, {
   3.77650976897101*^9, 3.776509788349681*^9}, {3.776509819888404*^9, 
   3.776509862357739*^9}, {3.776510467087731*^9, 3.776510495414528*^9}, {
   3.776510707548031*^9, 3.776510714276843*^9}, {3.776510784595417*^9, 
   3.7765107854524593`*^9}, {3.776520079247204*^9, 3.7765200964041147`*^9}, {
   3.776535377810006*^9, 
   3.7765353783043633`*^9}},ExpressionUUID->"4a0e8568-03be-46e1-bbc4-\
f4aa69d21521"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/thueroffpaper_single_DQ.dat\>\"", ",", 
    RowBox[{"Join", "[", 
     RowBox[{
     "result20", ",", "result30", ",", "result40", ",", "result50", ",", 
      "result60"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.740798527981938*^9, 3.740798603571829*^9}, 
   3.7422681386606417`*^9, {3.776509876186715*^9, 
   3.7765098917943983`*^9}},ExpressionUUID->"ae53f5a1-9f52-4e93-9cdf-\
f3393780fde3"]
},
WindowSize->{808, 755},
WindowMargins->{{7, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 14138, 333, 1270, "Input",ExpressionUUID->"4a0e8568-03be-46e1-bbc4-f4aa69d21521"],
Cell[14699, 355, 577, 13, 73, "Input",ExpressionUUID->"ae53f5a1-9f52-4e93-9cdf-f3393780fde3"]
}
]
*)

